% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplot_boxplot.R
\name{xplot_boxplot}
\alias{xplot_boxplot}
\title{Default xpose boxplot function}
\usage{
xplot_boxplot(
  xpdb,
  mapping = NULL,
  type = "bo",
  xscale = "discrete",
  yscale = "continuous",
  orientation = "x",
  group = "ID",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  tag = NULL,
  plot_name = "boxplot",
  gg_theme,
  xp_theme,
  opt,
  quiet,
  jitter_seed,
  ...
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> or <\code{xpose_data}> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{type}{See Details.}

\item{xscale}{Defaults to \code{discrete}.}

\item{yscale}{Defaults to \code{continuous}, used as check if \code{orientation} changed.}

\item{orientation}{Defaults to \code{x}}

\item{group}{Grouping for connecting lines through jitter}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{plot_name}{Metadata name of plot}

\item{gg_theme}{As in \code{xpose}}

\item{xp_theme}{As in \code{xpose}}

\item{opt}{Processing options for fetched data}

\item{quiet}{Silence extra debugging output}

\item{jitter_seed}{A numeric, optional seed to be used in jitters}

\item{...}{Any additional aesthetics.}
}
\value{
The desired plot
}
\description{
Manually generate boxplots from an xpdb object.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{b} box-whisker (using default quantiles)
\item \code{p} points (from \code{geom_dotplot})
\item \code{v} violin (from \code{geom_violin})
\item \code{o} outliers (show outliers)
\item \code{l} line through 0 (or as indicated in \code{hline_yintercept} or
\code{yline_xintercept})
\item \code{s} smooth line (from \code{geom_smooth})
\item \code{j} jitter points (from \code{geom_jitter})
\item \code{c} connecting lines for jitter points  (from \code{geom_path})
}
}
