% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record}
\alias{record}
\alias{format.xfun_record_results}
\alias{print.xfun_record_results}
\title{Run R code and record the results}
\usage{
record(
  code = NULL,
  dev = "png",
  dev.path = "xfun-record",
  dev.ext = dev_ext(dev),
  dev.args = list(),
  dev.keep = TRUE,
  message = TRUE,
  warning = TRUE,
  error = NA,
  cache = list(),
  print = record_print,
  print.args = list(),
  verbose = getOption("xfun.record.verbose", 0),
  envir = parent.frame()
)

\method{format}{xfun_record_results}(
  x,
  to = c("text", "markdown", "html"),
  encode = FALSE,
  template = FALSE,
  ...
)

\method{print}{xfun_record_results}(
  x,
  browse = interactive(),
  to = if (browse) "html" else "text",
  template = TRUE,
  ...
)
}
\arguments{
\item{code}{A character vector of R source code.}

\item{dev}{A graphics device. It can be a function name, a function, or a
character string that can be evaluated to a function to open a graphics
device.}

\item{dev.path}{A base file path for plots. Actual plot filenames will be
this base path plus incremental suffixes. For example, if \code{dev.path = "foo"}, the plot files will be \verb{foo-1.png}, \verb{foo-2.png}, and so on. If
\code{dev.path} is not character (e.g., \code{FALSE}), plots will not be recorded.}

\item{dev.ext}{The file extension for plot files. By default, it will be
inferred from the first argument of the device function if possible.}

\item{dev.args}{Extra arguments to be passed to the device. The default
arguments are \code{list(units = 'in', onefile = FALSE, width = 7, height = 7, res = 96)}. If any of these arguments is not present in the device
function, it will be dropped.}

\item{dev.keep}{Indices of plots to be kept. The indices can be either
numeric (positive or negative integers) or logical. Negative integers and
false values will remove the corresponding plots. For example, if the code
generated 3 plots, \code{dev.keep = c(1, 3)}, \code{-2}, and \code{c(T, F, T)} are
equivalent ways to remove the second plot. The special value \code{dev.keep = 'last'} means to keep the last plot only.}

\item{message, warning, error}{If \code{TRUE}, record and store messages / warnings
/ errors in the output. If \code{FALSE}, suppress them. If \code{NA}, do not process
them (messages will be emitted to the console, and errors will halt the
execution).}

\item{cache}{A list of options for caching. See the \code{path}, \code{id}, and \code{...}
arguments of \code{\link[=cache_exec]{cache_exec()}}.}

\item{print}{A (typically S3) function that takes the value of an expression
in the code as input and returns output. The default is \code{\link[=record_print]{record_print()}}.
If a non-function value (e.g., \code{NA}) is passed to this argument, \code{\link[=print]{print()}}
(or \code{\link[=show]{show()}} for S4 objects) will be used.}

\item{print.args}{A list of arguments for the \code{print} function. By default,
the whole list is not passed directly to the function, but only an element
in the list with a name identical to the first class name of the returned
value of the expression, e.g., \code{list(data.frame = list(digits = 3), matrix = list())}. This makes it possible to apply different print arguments to
objects of different classes. If the whole list is intended to be passed to
the print function directly, wrap the list in \code{\link[=I]{I()}}.}

\item{verbose}{\code{2} means to always print the value of each expression in the
code, no matter if the value is \code{\link[=invisible]{invisible()}} or not; \code{1} means to always
print the value of the last expression; \code{0} means no special handling
(i.e., print only when the value is visible).}

\item{envir}{An environment in which the code is evaluated.}

\item{x}{An object returned by \code{record()}.}

\item{to}{The output format (text, markdown, or html).}

\item{encode}{For HTML output, whether to base64 encode plots.}

\item{template}{For HTML output, whether to embed the formatted results in an
HTML template. Alternatively, this argument can take a file path, i.e.,
path to an HTML template that contains the variable \verb{$body$}. If \code{TRUE},
the default template in this package will be used
(\code{xfun:::pkg_file('resources', 'record.html')}).}

\item{...}{Currently ignored.}

\item{browse}{Whether to browse the results on an HTML page.}
}
\value{
\code{record()} returns a list of the class \code{xfun_record_results} that
contains elements with these possible classes: \code{record_source} (source
code), \code{record_output} (text output), \code{record_plot} (plot file paths),
\code{record_message} (messages), \code{record_warning} (warnings), and
\code{record_error} (errors, only when the argument \code{error = TRUE}).

The \code{format()} method returns a character vector of plain-text output
or HTML code for displaying the results.

The \code{print()} method prints the results as plain text or HTML to the
console or displays the HTML page.
}
\description{
Run R code and capture various types of output, including text output, plots,
messages, warnings, and errors.
}
\examples{
code = c("# a warning test", "1:2 + 1:3", "par(mar = c(4, 4, 1, .2))",
    "barplot(5:1, col = 2:6, horiz = TRUE)", "head(iris)",
    "sunflowerplot(iris[, 3:4], seg.col = 'purple')",
    "if (TRUE) {\n  message('Hello, xfun::record()!')\n}",
    "# throw an error", "1 + 'a'")
res = xfun::record(code, dev.args = list(width = 9, height = 6.75),
    error = TRUE)
xfun::tree(res)
format(res)
# find and clean up plot files
plots = Filter(function(x) inherits(x, "record_plot"),
    res)
file.remove(unlist(plots))
}
