% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_delta.R
\name{pairwise_delta}
\alias{pairwise_delta}
\alias{pairwise_delta_}
\title{Delta measure of pairs of documents}
\usage{
pairwise_delta(tbl, item, feature, value, method = "burrows", ...)

pairwise_delta_(tbl, item, feature, value, method = "burrows", ...)
}
\arguments{
\item{tbl}{Table}

\item{item}{Item to compare; will end up in \code{item1} and
\code{item2} columns}

\item{feature}{Column describing the feature that links one item to others}

\item{value}{Value}

\item{method}{Distance measure to be used; see \code{\link[=dist]{dist()}}}

\item{...}{Extra arguments passed on to \code{\link[=squarely]{squarely()}},
such as \code{diag} and \code{upper}}
}
\description{
Compute the delta distances (from its two variants) of all pairs of documents in a tidy table.
}
\examples{

library(janeaustenr)
library(dplyr)
library(tidytext)

# closest documents in terms of 1000 most frequent words
closest <- austen_books() \%>\%
  unnest_tokens(word, text) \%>\%
  count(book, word) \%>\%
  top_n(1000, n) \%>\%
  pairwise_delta(book, word, n, method = "burrows") \%>\%
  arrange(delta)

closest

closest \%>\%
  filter(item1 == "Pride & Prejudice")

# to remove duplicates, use upper = FALSE
closest <- austen_books() \%>\%
  unnest_tokens(word, text) \%>\%
  count(book, word) \%>\%
  top_n(1000, n) \%>\%
  pairwise_delta(book, word, n, method = "burrows", upper = FALSE) \%>\%
  arrange(delta)

# Can also use Argamon's Linear Delta
closest <- austen_books() \%>\%
  unnest_tokens(word, text) \%>\%
  count(book, word) \%>\%
  top_n(1000, n) \%>\%
  pairwise_delta(book, word, n, method = "argamon", upper = FALSE) \%>\%
  arrange(delta)

}
\seealso{
\code{\link[=squarely]{squarely()}}
}
