
test_that("ESPN - WNBA Team Stats", {
  skip_on_cran()
  x <- espn_wnba_team_stats(team_id = 18, year = 2020)
  cols <- c(
    "team_id",
    "team_guid",
    "team_uid",
    "team_sdr",
    "team_slug",
    "team_location",
    "team_name",
    "team_abbreviation",
    "team_display_name",
    "team_short_display_name",
    "team_color",
    "team_alternate_color",
    "team_is_active",
    "team_is_all_star",
    "logo_href",
    "logo_dark_href",
    "general_disqualifications",
    "general_flagrant_fouls",
    "general_fouls",
    "general_ejections",
    "general_technical_fouls",
    "general_rebounds",
    "general_avg_minutes",
    "general_nba_rating",
    "general_plus_minus",
    "general_game_day_of_year",
    "general_avg_rebounds",
    "general_avg_fouls",
    "general_avg_flagrant_fouls",
    "general_avg_technical_fouls",
    "general_avg_ejections",
    "general_avg_disqualifications",
    "general_assist_turnover_ratio",
    "general_steal_foul_ratio",
    "general_block_foul_ratio",
    "general_avg_team_rebounds",
    "general_total_rebounds",
    "general_total_technical_fouls",
    "general_team_assist_turnover_ratio",
    "general_team_rebounds",
    "general_steal_turnover_ratio",
    "general_avg48rebounds",
    "general_avg48fouls",
    "general_avg48flagrant_fouls",
    "general_avg48technical_fouls",
    "general_avg48ejections",
    "general_avg48disqualifications",
    "general_games_played",
    "general_games_started",
    "general_double_double",
    "general_triple_double",
    "offensive_assists",
    "offensive_field_goals",
    "offensive_field_goals_attempted",
    "offensive_field_goals_made",
    "offensive_field_goal_pct",
    "offensive_free_throws",
    "offensive_free_throw_pct",
    "offensive_free_throws_attempted",
    "offensive_free_throws_made",
    "offensive_offensive_rebounds",
    "offensive_points",
    "offensive_turnovers",
    "offensive_three_point_pct",
    "offensive_three_point_field_goals_attempted",
    "offensive_three_point_field_goals_made",
    "offensive_team_turnovers",
    "offensive_total_turnovers",
    "offensive_points_in_paint",
    "offensive_brick_index",
    "offensive_avg_field_goals_made",
    "offensive_avg_field_goals_attempted",
    "offensive_avg_three_point_field_goals_made",
    "offensive_avg_three_point_field_goals_attempted",
    "offensive_avg_free_throws_made",
    "offensive_avg_free_throws_attempted",
    "offensive_avg_points",
    "offensive_avg_points_allowed",
    "offensive_avg_offensive_rebounds",
    "offensive_avg_assists",
    "offensive_avg_turnovers",
    "offensive_offensive_rebound_pct",
    "offensive_estimated_possessions",
    "offensive_avg_estimated_possessions",
    "offensive_points_per_estimated_possessions",
    "offensive_avg_team_turnovers",
    "offensive_avg_total_turnovers",
    "offensive_three_point_field_goal_pct",
    "offensive_two_point_field_goals_made",
    "offensive_two_point_field_goals_attempted",
    "offensive_avg_two_point_field_goals_made",
    "offensive_avg_two_point_field_goals_attempted",
    "offensive_two_point_field_goal_pct",
    "offensive_shooting_efficiency",
    "offensive_scoring_efficiency",
    "offensive_avg48field_goals_made",
    "offensive_avg48field_goals_attempted",
    "offensive_avg48three_point_field_goals_made",
    "offensive_avg48three_point_field_goals_attempted",
    "offensive_avg48free_throws_made",
    "offensive_avg48free_throws_attempted",
    "offensive_avg48points",
    "offensive_avg48offensive_rebounds",
    "offensive_avg48assists",
    "offensive_avg48turnovers",
    "defensive_blocks",
    "defensive_defensive_rebounds",
    "defensive_steals",
    "defensive_avg_defensive_rebounds",
    "defensive_avg_blocks",
    "defensive_avg_steals",
    "defensive_avg48defensive_rebounds",
    "defensive_avg48blocks",
    "defensive_avg48steals"
  )
  
  expect_in(sort(colnames(x)), sort(cols))
  expect_s3_class(x, "data.frame")
})
