% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_pbp.R
\name{wnba_pbps}
\alias{wnba_pbps}
\title{\strong{Get WNBA Stats API play-by-play (Multiple Games)}}
\usage{
wnba_pbps(
  game_ids = NULL,
  on_court = TRUE,
  version = "v2",
  nest_data = FALSE,
  ...
)
}
\arguments{
\item{game_ids}{Game IDs}

\item{on_court}{IF TRUE will be added ID of players on court}

\item{version}{Play-by-play version ("v2" available from 2016-17 onwards)}

\item{nest_data}{If TRUE returns nested data by game}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a data frame: PlayByPlay\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   event_num \tab character \cr
   event_type \tab character \cr
   event_action_type \tab character \cr
   period \tab numeric \cr
   minute_game \tab numeric \cr
   time_remaining \tab numeric \cr
   wc_time_string \tab character \cr
   time_quarter \tab character \cr
   minute_remaining_quarter \tab numeric \cr
   seconds_remaining_quarter \tab numeric \cr
   home_description \tab character \cr
   neutral_description \tab character \cr
   visitor_description \tab character \cr
   score \tab character \cr
   away_score \tab numeric \cr
   home_score \tab numeric \cr
   score_margin \tab character \cr
   person1type \tab character \cr
   player1_id \tab character \cr
   player1_name \tab character \cr
   player1_team_id \tab character \cr
   player1_team_city \tab character \cr
   player1_team_nickname \tab character \cr
   player1_team_abbreviation \tab character \cr
   person2type \tab character \cr
   player2_id \tab character \cr
   player2_name \tab character \cr
   player2_team_id \tab character \cr
   player2_team_city \tab character \cr
   player2_team_nickname \tab character \cr
   player2_team_abbreviation \tab character \cr
   person3type \tab character \cr
   player3_id \tab character \cr
   player3_name \tab character \cr
   player3_team_id \tab character \cr
   player3_team_city \tab character \cr
   player3_team_nickname \tab character \cr
   player3_team_abbreviation \tab character \cr
   video_available_flag \tab character \cr
   team_leading \tab character \cr
   away_player1 \tab numeric \cr
   away_player2 \tab numeric \cr
   away_player3 \tab numeric \cr
   away_player4 \tab numeric \cr
   away_player5 \tab numeric \cr
   home_player1 \tab numeric \cr
   home_player2 \tab numeric \cr
   home_player3 \tab numeric \cr
   home_player4 \tab numeric \cr
   home_player5 \tab numeric \cr
}
}
\description{
\strong{Get WNBA Stats API play-by-play (Multiple Games)}

\strong{Get WNBA Stats API play-by-play (Multiple Games)}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y <- c("1022200034", "1022200035" )

wnba_pbps(game_ids = y, version = "v2")
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA PBP Functions: 
\code{\link{wnba_data_pbp}()},
\code{\link{wnba_live_pbp}()},
\code{\link{wnba_pbp}()}
}
\author{
Jason Lee
}
\concept{WNBA PBP Functions}
