% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_league.R
\name{wnba_leaguegamelog}
\alias{wnba_leaguegamelog}
\title{\strong{Get WNBA Stats API League Game Log}}
\usage{
wnba_leaguegamelog(
  counter = 0,
  date_from = "",
  date_to = "",
  direction = "ASC",
  league_id = "00",
  player_or_team = "T",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  sorter = "DATE",
  ...
)
}
\arguments{
\item{counter}{counter}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{direction}{direction}

\item{league_id}{league_id}

\item{player_or_team}{player_or_team}

\item{season}{season}

\item{season_type}{season_type}

\item{sorter}{sorter}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: LeagueGameLog

\strong{LeagueGameLog}\tabular{ll}{
   col_name \tab types \cr
   SEASON_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   GAME_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   VIDEO_AVAILABLE \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Game Log}

\strong{Get WNBA Stats API League Game Log}
}
\details{
\href{https://stats.wnba.com/players/boxscores-traditional/}{Player/Team Boxscores}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_leaguegamelog(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA League Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leaguedashteamclutch}()},
\code{\link{wnba_leaguedashteamshotlocations}()},
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_leaguegamefinder}()},
\code{\link{wnba_leaguelineupviz}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_leaguestandingsv3}()},
\code{\link{wnba_shotchartleaguewide}()}
}
\author{
Saiem Gilani
}
\concept{WNBA League Functions}
