% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_league_dash.R
\name{wnba_leaguedashteamshotlocations}
\alias{wnba_leaguedashteamshotlocations}
\title{\strong{Get WNBA Stats API League Dashboard Team Shot Locations}}
\usage{
wnba_leaguedashteamshotlocations(
  conference = "",
  date_from = "",
  date_to = "",
  distance_range = "By Zone",
  division = "",
  game_scope = "",
  game_segment = "",
  last_n_games = 0,
  league_id = "10",
  location = "",
  measure_type = "Base",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  player_experience = "",
  player_position = "",
  plus_minus = "N",
  rank = "N",
  season = most_recent_wnba_season() - 1,
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  starter_bench = "",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{distance_range}{distance_range}

\item{division}{division}

\item{game_scope}{game_scope}

\item{game_segment}{game_segment}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{measure_type}{measure_type}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_experience}{player_experience}

\item{player_position}{player_position}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{starter_bench}{starter_bench}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: ShotLocations

\strong{ShotLocations}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   Restricted_Area_FGM \tab character \cr
   Restricted_Area_FGA \tab character \cr
   Restricted_Area_FG_PCT \tab character \cr
   In_The_Paint_Non_RA_FGM \tab character \cr
   In_The_Paint_Non_RA_FGA \tab character \cr
   In_The_Paint_Non_RA_FG_PCT \tab character \cr
   Mid_Range_FGM \tab character \cr
   Mid_Range_FGA \tab character \cr
   Mid_Range_FG_PCT \tab character \cr
   Left_Corner_3_FGM \tab character \cr
   Left_Corner_3_FGA \tab character \cr
   Left_Corner_3_FG_PCT \tab character \cr
   Right_Corner_3_FGM \tab character \cr
   Right_Corner_3_FGA \tab character \cr
   Right_Corner_3_FG_PCT \tab character \cr
   Above_the_Break_3_FGM \tab character \cr
   Above_the_Break_3_FGA \tab character \cr
   Above_the_Break_3_FG_PCT \tab character \cr
   Backcourt_FGM \tab character \cr
   Backcourt_FGA \tab character \cr
   Backcourt_FG_PCT \tab character \cr
   Corner_3_FGM \tab character \cr
   Corner_3_FGA \tab character \cr
   Corner_3_FG_PCT \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Dashboard Team Shot Locations}

\strong{Get WNBA Stats API League Dashboard Team Shot Locations}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_leaguedashteamshotlocations(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA League Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leaguedashteamclutch}()},
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_leaguegamefinder}()},
\code{\link{wnba_leaguegamelog}()},
\code{\link{wnba_leaguelineupviz}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_leaguestandingsv3}()},
\code{\link{wnba_shotchartleaguewide}()}

Other WNBA Shooting Functions: 
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_shotchartdetail}()},
\code{\link{wnba_shotchartleaguewide}()},
\code{\link{wnba_shotchartlineupdetail}()},
\code{\link{wnba_teamdashboardbyshootingsplits}()}
}
\author{
Saiem Gilani
}
\concept{WNBA League Functions}
\concept{WNBA Shooting Functions}
