% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_hydro_layer}
\alias{get_hydro_layer}
\title{Retrieve WDNR's HYDRO spatial layer}
\usage{
get_hydro_layer(
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  wbic = NULL,
  where = NULL,
  layer_type = "polygons",
  ...
)
}
\arguments{
\item{county}{A character object specifying a county name}

\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{sf_object}{Any sf polygon object}

\item{wbic}{A character object or string of WBIC's}

\item{where}{SQL statement}

\item{layer_type}{"lines", "polygons", or "flowlines"}

\item{...}{Additional parameters to pass to
\code{\link[arcpullr]{get_spatial_layer}}}
}
\value{
An sf object of class polylines of polygons
}
\description{
A function that can be used to retrieve WDNR's 24k Hydrography (HYDRO) layer.
Either the"24K Hydrography Streams and Rivers" or the
"24K Hydrography Lakes and Open Water" can be queried by setting 'layer_type'
to 'lines' or 'polygons' respectively.
A spatial query can be performed to limit the output of the function by
supplying a county name, watershed code, watershed name, or custom sf polygon
object. Use the 'watershed_lookup' to find valid watershed codes and names.
WBIC's can also be provided in order to return features for
specific waterbodies. The 'where' arguement can be used to run
custom SQL queries.
}
\details{
This function will retrieve WDNR's hydro layer.  A county, watershed code,
watershed_name, or custom sf polygon can be specifie to filter the layer.
The layer type can be specified to query either the polylines or polygons
hydro spatial layers.
}
\examples{
\dontrun{
get_hydro_layer(county = "milwaukee", layer_type = "lines")
get_hydro_layer(watershed_code = "07070006", layer_type = "polygons")
get_hydro_layer(wbic = c("549400", "15000"), layer_type = "polygons")
get_hydro_layer(county = "milwaukee", where = "HYDROTYPE = '508'")
}
}
