% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseq_2x3.R
\name{deseq_2x3}
\alias{deseq_2x3}
\title{2 x 3 factor DESeq2 analysis}
\usage{
deseq_2x3(object, design, group, ...)
}
\arguments{
\item{object}{An object of class 'DESeqDataSet' containing full dataset}

\item{design}{Design formula. The main contrast is taken from the last term
of the formula and must be a binary factor.}

\item{group}{Character value for the column with the 3-way grouping factor
within the sample information data \code{colData}}

\item{...}{Optional arguments passed to \code{DESeq()}.}
}
\value{
Returns a list of 3 DESeq2 results objects which can be passed onto
\code{\link[=deseq_2x3_polar]{deseq_2x3_polar()}}
}
\description{
Experimental function for performing 2x3 factor DESeq2 analyses. Output can
be passed to \code{\link[=deseq_2x3_polar]{deseq_2x3_polar()}} and subsequently plotted. Example usage
would include comparing gene expression against a binary outcome e.g.
response vs non-response, across 3 drugs: the design would be \code{~ response}
and \code{group} would refer to the medication column in the metadata.
}
\examples{
\dontshow{if (rlang::is_installed("DESeq2")) withAutoprint(\{ # examplesIf}

\donttest{
# Basic DESeq2 set up

  library(DESeq2)
  counts <- matrix(rnbinom(n=3000, mu=100, size=1/0.5), ncol=30)
  rownames(counts) <- paste0("gene", 1:100)
  cond <- rep(factor(rep(1:3, each=5), labels = c('A', 'B', 'C')), 2)
  resp <- factor(rep(1:2, each=15), labels = c('non.responder', 'responder'))
  metadata <- data.frame(drug = cond, response = resp)
  
  # Full dataset object construction
  dds <- DESeqDataSetFromMatrix(counts, metadata, ~response)
  
  # Perform 3x DESeq2 analyses comparing binary response for each drug
  res <- deseq_2x3(dds, ~response, "drug")
  
  # Generate polar object
  obj <- deseq_2x3_polar(res)
  
  # 2d plot
  radial_plotly(obj)
  
  # 3d plot
  volcano3D(obj)
}
\dontshow{\}) # examplesIf}
}
