% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAudio.R
\name{readAudio}
\alias{readAudio}
\title{Read Audio Files}
\usage{
readAudio(path = ".", filter = c(), fileType = "wav", recursive = FALSE)
}
\arguments{
\item{path}{Character string indicating the full path to the folder containing the audio files. Default corresponds to the current working directory.}

\item{filter}{Optional character vector, containing patterns, such as IDs or conditions of each audio file.}

\item{fileType}{Character string indicating the file format (wav or mp3) of the audio files. Default corresponds to wav.}

\item{recursive}{A logical value indicating whether subdirectories should be included when searching for voice files. Default corresponds to FALSE.}
}
\value{
Returns a list of Wave objects.
}
\description{
Loads all audio files in the specified directory and provides the option to filter via ID, conditions, and/or dimensions.
}
\examples{
readAudio(system.file("Audios", package = "voiceR"),
fileType = "wav", recursive = TRUE)

}
