% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm.sr.R
\name{cm.sr}
\alias{cm.sr}
\title{Selecting the best 2-Band combinations for Simple Ratio (SR)}
\usage{
cm.sr(S, x, w = wavelength(S), w.unit = NULL, cm.plot = FALSE)
}
\arguments{
\item{S}{A matrix of spectral data, where each row is a spectrum across all spectral bands.}

\item{x}{A numeric vector (e.g., a vegetation variable).}

\item{w}{A numeric vector of wavelengths; by default it is derived using \code{wavelength(S)}.}

\item{w.unit}{A character string specifying the unit of wavelengths (default is \code{NULL}).}

\item{cm.plot}{Logical. If \code{TRUE}, the correlation coefficient matrix is plotted.}
}
\value{
\item{cm}{Returns a correlation coefficients matrix.}
}
\description{
This function develops an optimization algorithm based on correlation analysis between the spectral matrix \code{spectra} and the
vegetation variable of interest \code{x}. It determines the best spectral band combinations of the full spectrum that are most predictive for \code{x}.
}
\details{
This function runs a calculation of \deqn{ SR = \lambda_i / \lambda_j } using the spectra data for all the possible pairs/combinations of any two bands (i, j)
within the full spectrum range. Next, correlation analysis is then performed between all possible SR values and another vector variable \code{y}, and it returns
the squared Pearson correlation (\eqn{R^2}) which indicates the predictive performance of each SR and its corresponding two-band combination. The
output is the wavelength (nm) indicating the best two bands that produce the highest value of \eqn{R^2}.
}
\examples{
\dontrun{
  library(visa)
  data(NSpec.DF)
  # Using the example spectra matrix of the spectra.dataframe
  X <- NSpec.DF$spectra[, seq(1, ncol(NSpec.DF$spectra), 10)]  # resampled to 10 nm steps
  y <- NSpec.DF$N  # nitrogen
  cm <- cm.sr(X, y, cm.plot = FALSE)
}

}
\seealso{
\code{\link{cm.nsr}}
}
