"Phi.svarest" <-
function(x, nstep = 10, ...){
  if(!is(x, "svarest")){
    stop("\nPlease provide an object of class 'svarest', generated by 'SVAR()'.\n")
  }
  nstep <- abs(as.integer(nstep))
  Ainv <- solve(x$A)
  Phi <- Phi(x$var, nstep = nstep)
  for(i in 1: dim(Phi)[3]){
    Phi[, , i] <- Phi[, , i] %*% Ainv %*% x$B
  }
  return(Phi)
}
