% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\docType{data}
\name{.IDvars}
\alias{.IDvars}
\alias{.Tvars}
\title{Global Identifier Macros}
\usage{
.IDvars
.Tvars
}
\description{
The macro \code{.IDvars} contains the string \code{c("DSID", "Series")} denoting
variables that uniquely identify series in the database.
\emph{Note} that the series code contained in "Series" alone is not sufficient to uniquely identify a series as some
series are recorded with the same code in multiple datasets (mostly either the same data aggregated at a different frequency, or a different collection of indicators).
For example goods exports with the series code "EX_G" are recorded in the datasets "BOU_MMI", "BOU_MMI_A" (annual data), and "BOU_MMI_FY" (fiscal year data).

The macro \code{.Tvars} contains the string
\code{c("Date", "Year", "Quarter", "FY", "QFY", "Month", "Day")} denoting temporal identifiers generated by \code{\link{expand_date}}.
The "Date" variable is sufficient to uniquely identify a point in time in the database.
}
\examples{
.IDvars
.Tvars


}
\seealso{
\code{\link{ugatsdb}}
}
\keyword{datasets}
