% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_hidden.r
\name{tt_search_hidden}
\alias{tt_search_hidden}
\title{Search videos}
\usage{
tt_search_hidden(
  query,
  solve_captchas = FALSE,
  timeout = 5L,
  scroll = "5m",
  return_urls = FALSE,
  save_video = FALSE,
  verbose = interactive(),
  headless = TRUE,
  ...
)
}
\arguments{
\item{query}{query as one string.}

\item{solve_captchas}{open browser to solve appearing captchas manually.}

\item{timeout}{time (in seconds) to wait between scrolling and solving
captchas.}

\item{scroll}{how long to keep scrolling before returning results. Can be a
numeric value of seconds or a string with seconds, minutes, hours or days
(see examples).}

\item{return_urls}{return video URLs instead of downloading the vidoes.}

\item{save_video}{passed to \code{\link{tt_videos_hidden}} if \code{return_urls = FALSE}.}

\item{verbose}{should the function print status updates to the screen?}

\item{headless}{open the browser to show the scrolling.}

\item{...}{Additional arguments to be passed to the
\code{\link{tt_videos_hidden}} function.}
}
\value{
a data.frame containing metadata searched posts or character vector
of URLs.
}
\description{
\ifelse{html}{\figure{api-unofficial.svg}{options: alt='[Works
  on: Unofficial API]'}}{\strong{[Works on: Unofficial API]}}

This is the version of \link{tt_search} that explicitly uses the unofficial
API. Use \link{tt_search_api} for the Research API version.
}
\details{
The function will wait between scraping search results. To get more
than 6 videos, you need to provide cookies of a logged in account. For more
details see the unofficial-api vignette: \code{vignette("unofficial-api",
  package = "traktok")}
}
\examples{
\dontrun{
# search videos with hastag #rstats for default time
tt_search_hidden("#rstats")

# search videos for 10 seconds
tt_search_hidden("#rstats", scroll = "10s")
tt_search_hidden("#rstats", scroll = 10)

# search videos for 10 minutes
tt_search_hidden("#rstats", scroll = "10m")
tt_search_hidden("#rstats", scroll = "10mins")

# search videos for 10 hours
tt_search_hidden("#rstats", scroll = "10h")
tt_search_hidden("#rstats", scroll = "10hours")

# search videos until all are found
tt_search_hidden("#rstats", scroll = Inf)
# the functions runs until the end of all search results, which can take a
# long time. You can cancel the search and retrieve all collected results
# with last_query though!
last_query()
}
}
