% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_hidden.r
\name{tt_get_following_hidden}
\alias{tt_get_following_hidden}
\alias{tt_get_follower_hidden}
\title{Get followers and following of a user from the hidden API}
\usage{
tt_get_following_hidden(
  secuid,
  sleep_pool = 1:10,
  max_tries = 5L,
  cookiefile = NULL,
  verbose = interactive()
)

tt_get_follower_hidden(
  secuid,
  sleep_pool = 1:10,
  max_tries = 5L,
  cookiefile = NULL,
  verbose = interactive()
)
}
\arguments{
\item{secuid}{The secuid of a user. You can get it with
\link{tt_user_info_hidden} by querying an account (see example).}

\item{sleep_pool}{a vector of numbers from which a waiting period is randomly
drawn.}

\item{max_tries}{how often to retry if a request fails.}

\item{cookiefile}{path to your cookiefile. Usually not needed after running
\link{auth_hidden} once. See \code{vignette("unofficial-api", package =
  "traktok")} for more information on authentication.}

\item{verbose}{should the function print status updates to the screen?}
}
\value{
a data.frame of followers
}
\description{
\ifelse{html}{\figure{api-unofficial.svg}{options: alt='[Works on:
  Unofficial API]'}}{\strong{[Works on: Unofficial API]}}

Get up to 5,000 accounts who follow a user or accounts a user follows.
}
\examples{
\dontrun{
df <- tt_user_info_hidden("https://www.tiktok.com/@fpoe_at")
tt_get_follower_hidden(df$secUid)
}
}
