% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge.tind}
\title{Merging Time-indexed Data}
\usage{
\method{merge}{tind}(x, y, ..., all = FALSE, all.x = all, all.y = all)
}
\arguments{
\item{x, y}{an object of \code{tind} class.}

\item{...}{(optional) further time indices.}

\item{all}{a logical value, equivalent to setting both \code{all.x}
and \code{all.y} to the same value. Alternatively, a logical
vector in case of more than 2 arguments. See Details.}

\item{all.x}{a logical value, if \code{TRUE}, all \code{x} observations
are included in the result even if there are no corresponding
time indices in \code{y}.}

\item{all.y}{a logical value, analogous to \code{all.x}.}
}
\value{
A three-element list with the first element (\code{index}) containing
the final time indices, and the remaining two (\code{xi} and \code{yi})
mappings from \code{x} and \code{y} to these indices. If additional time
indices are provided, the length of the returned list equals the number of
all arguments (including \code{x} and \code{y}) plus one (for the final index
at the beginning of the list).
}
\description{
\code{merge} method for \code{tind} allows to join two (or more) time-indexed
datasets also in cases when the indices are of different types. The method
is intended for advanced users.

The method takes two \code{tind} vectors (\code{x} and \code{y}) and returns
a three-element list containing resulting indices and mappings (integer
indices) from the original indices to the final ones allowing to select
appropriate rows from dataset indexed by \code{x} and \code{y}, see Examples.
}
\details{
By default (\code{all = FALSE}), inner join is performed. \code{x} and \code{y}
can be indices of different types but conversion of the higher resolution
to the lower should be possible.

If \code{all.x = TRUE}, left join is performed. All indices from \code{x}
are preserved. \code{y} can then be of the same or lower resolution than \code{x}.

If \code{all.y = TRUE}, right join is performed. All indices from \code{y}
are preserved. \code{x} can then be of the same or lower resolution than \code{y}.

If \code{all = TRUE}, outer join is performed. All indices from \code{x}
and \code{y} are preserved. Indices in \code{x} and \code{y} have to be
of the same type in this case.

Setting \code{all} argument silently overrides both \code{all.x} and \code{all.y}.

\code{NA}s are \emph{never} matched.

The method is optimized in case both indices are strictly increasing without
\code{NA}s (time series applications). In other cases, it employs
\code{\link[base]{merge}} method for specially constructed data frames.

The method also accepts more than two arguments (time indices). In this case,
it is expected that all are strictly increasing without \code{NA}s (time
series applications only). \code{all.x} and \code{all.y} cannot be used
with more than two arguments.

\code{all} can be a vector of logical values indicating which indices have
to always be included in the result (\code{TRUE}) and which have to be
matched (\code{FALSE}). In 2-argument case, for example, \code{all = c(TRUE, FALSE)}
is equivalent to \code{all.x = TRUE} and \code{all = c(FALSE, TRUE)}
to \code{all.y = TRUE}.
}
\examples{
# construct sample data frames
(dates1 <- tind(y = 2023, m = rep(1:4, each = 2), d = c(1, 16)))
(dates2 <- dates1 \%+m\% 1)
(mnths <- as.month("2022-12") + 0:3)
(df1 <- data.frame(dates1, nd1 = as.numeric(dates1),
                   downame = day_of_week(dates1, labels = TRUE, abbreviate = FALSE)))
(df2 <- data.frame(dates2, nd2 = as.numeric(dates2), dow = day_of_week(dates2)))
(df3 <- data.frame(mnths, nm = as.numeric(mnths),
                   mname = month(mnths, labels = TRUE, abbreviate = FALSE)))
# inner join - dates
(mti <- merge(df1[[1L]], df2[[1L]]))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df2[mti[[3L]], -1L, drop = FALSE])
# inner join - dates and months
(mti <- merge(df1[[1L]], df3[[1L]]))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df3[mti[[3L]], -1L, drop = FALSE])
# left join - dates
(mti <- merge(df1[[1L]], df2[[1L]], all.x = TRUE))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df2[mti[[3L]], -1L, drop = FALSE])
# left join - dates and months
(mti <- merge(df1[[1L]], df3[[1L]], all.x = TRUE))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df3[mti[[3L]], -1L, drop = FALSE])
# right join - dates
(mti <- merge(df1[[1L]], df2[[1L]], all.y = TRUE))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df2[mti[[3L]], -1L, drop = FALSE])
# right join - months and dates
(mti <- merge(df3[[1L]], df2[[1L]], all.y = TRUE))
data.frame(index = mti[[1L]],
           df3[mti[[2L]], -1L, drop = FALSE],
           df2[mti[[3L]], -1L, drop = FALSE])
# outer join - dates
(mti <- merge(df1[[1L]], df2[[1L]], all = TRUE))
data.frame(index = mti[[1L]],
           df1[mti[[2L]], -1L, drop = FALSE],
           df2[mti[[3L]], -1L, drop = FALSE])

}
\seealso{
\code{\link{match_t}} for matching time indices.
}
