% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.KaplanMeier}
\alias{print.KaplanMeier}
\title{Print function for object of class 'KaplanMeier'}
\usage{
\method{print}{KaplanMeier}(x, digits = 4, type = "risk", method = NULL, ...)
}
\arguments{
\item{x}{an object of class 'KaplanMeier'}

\item{digits}{number of digits to print the results}

\item{type}{either "surv" or "risk" (the default), depending on whether we want to print the results in terms of a survival probability or a risk (i.e., one minus the survival probability).}

\item{method}{either "EL", "Wald" or "both", depending on whether we want to print the results obtained when using empirical likelihood inference (EL), Wald-type inference (Wald) or both. Default is 'NULL', which means that 'method' inherits the value of the corresponding control parameter used when creating the object 'x'.}

\item{...}{Not used}
}
\value{
no return value, called for printing only.
}
\description{
Print function for object of class 'KaplanMeier'
}
\examples{
# This example reproduces some results presented in Table 1 of Thomas and Grunkemeier (1975)
ResKM.1.95 <- KaplanMeier(time=Freireich$time[Freireich$group==1],
                          status=Freireich$status[Freireich$group==1],
                          t=10, level=0.95, contr=list(tol=1e-4))
print(ResKM.1.95, digits=3, type="surv", method="EL")   # EL results for survival
print(ResKM.1.95, digits=3, type="risk", method="Wald") # Wald results for risk

}
\author{
Paul Blanche
}
