% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{document}
\alias{document}
\title{Recursively generate test listings across a testthat tree}
\usage{
document(
  root = "tests/testthat",
  pattern = "^[Tt]est.*\\\\.[rR]$",
  recurse = TRUE,
  exclude = c("testthat.R"),
  section_prefix = "# -",
  template = c("simple", "advanced", "custom"),
  global_fmt = NULL,
  section_fmt = NULL,
  encoding = "UTF-8",
  backup = TRUE,
  write = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{root}{Character. Root directory to search. Default \code{"tests/testthat"}.}

\item{pattern}{Regular expression used with \code{list.files(..., pattern=)} to
select test files. Default matches typical testthat files: \code{"^[Tt]est.*\\.[rR]$"}.}

\item{recurse}{Logical. Whether to search subdirectories recursively. Default \code{TRUE}.}

\item{exclude}{Character vector of basenames to exclude (e.g., \code{"testthat.R"}).
Default \code{c("testthat.R")}.}

\item{section_prefix}{Character scalar. Lines starting with this prefix denote
sections and are converted to \verb{#' @testsSection}. Default \code{"# -"}.}

\item{template}{One of \code{c("simple", "advanced", "custom")}. Controls the
default numbering format(s). Default \code{"simple"}.}

\item{global_fmt}{Character. Numbering template for the global listing. Uses
placeholders \code{{g}}, \code{{s}}, \code{{i}}, \code{{l}}. If \code{NULL},
it is derived from \code{template}.}

\item{section_fmt}{Character. Numbering template for section listings.
If \code{NULL}, it is derived from \code{template}.}

\item{encoding}{File encoding for reading and writing. Default \code{"UTF-8"}.}

\item{backup}{Logical. If \code{TRUE}, save a timestamped backup before
overwriting. Default \code{TRUE}.}

\item{write}{Logical. If \code{TRUE}, write changes back to \code{path}.
If \code{FALSE}, return the would-be modified text without writing. Default \code{TRUE}.}

\item{quiet}{Logical. If \code{FALSE} (default), prints progress messages.}
}
\value{
A list with components:
\itemize{
\item \code{files}: character vector of processed file paths
\item \code{results}: named list of \code{tests_listing_result} objects per file
\item \code{listing}: combined data frame with a \code{file} column
\item \code{backups}: character vector of backup paths (for files that were written)
}
}
\description{
Walks the \code{tests/testthat} directory (by default), finds test files,
and runs \code{\link{document_file}} on each matching file. All
options from \code{document_file()} are available here as pass-through
parameters.
}
\examples{
\dontrun{
  all_res <- document(
    root = "tests/testthat",
    template = "advanced",
    backup = TRUE,
    write = TRUE
  )
  head(all_res$listing)
}
}
