% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replymarkup.R
\name{InlineKeyboardMarkup}
\alias{InlineKeyboardMarkup}
\title{Create an inline keyboard markup}
\usage{
InlineKeyboardMarkup(inline_keyboard)
}
\arguments{
\item{inline_keyboard}{List of button rows, each represented by a list of
\code{\link{InlineKeyboardButton}} objects.}
}
\description{
This object represents an
\href{https://core.telegram.org/bots#inline-keyboards-and-on-the-fly-updating}{inline keyboard}
that appears right next to the message it belongs to.
}
\details{
\strong{Note:} After the user presses a callback button,
Telegram clients will display a progress bar until you call
\code{\link{answerCallbackQuery}}. It is, therefore, necessary to
react by calling \code{\link{answerCallbackQuery}} even if no notification
to the user is needed (e.g., without specifying any of the
optional parameters).
}
\examples{
\dontrun{
# Initialize bot
bot <- Bot(token = "TOKEN")
chat_id <- "CHAT_ID"

# Create Inline Keyboard
text <- "Could you type their phone number, please?"
IKM <- InlineKeyboardMarkup(
  inline_keyboard = list(
    list(
      InlineKeyboardButton(1),
      InlineKeyboardButton(2),
      InlineKeyboardButton(3)
    ),
    list(
      InlineKeyboardButton(4),
      InlineKeyboardButton(5),
      InlineKeyboardButton(6)
    ),
    list(
      InlineKeyboardButton(7),
      InlineKeyboardButton(8),
      InlineKeyboardButton(9)
    ),
    list(
      InlineKeyboardButton("*"),
      InlineKeyboardButton(0),
      InlineKeyboardButton("#")
    )
  )
)

# Send Inline Keyboard
bot$sendMessage(chat_id, text, reply_markup = IKM)
}
}
