% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survdnn.R
\name{build_dnn}
\alias{build_dnn}
\title{Build a Deep Neural Network for Survival Analysis}
\usage{
build_dnn(
  input_dim,
  hidden,
  activation = "relu",
  output_dim = 1L,
  dropout = 0.3,
  batch_norm = TRUE
)
}
\arguments{
\item{input_dim}{Integer. Number of input features.}

\item{hidden}{Integer vector. Sizes of the hidden layers (e.g., c(32, 16)).}

\item{activation}{Character. Name of the activation function to use in each layer.
Supported options: `"relu"`, `"leaky_relu"`, `"tanh"`, `"sigmoid"`, `"gelu"`, `"elu"`, `"softplus"`.}

\item{output_dim}{Integer. Output layer dimension (default = 1).}

\item{dropout}{Numeric between 0 and 1. Dropout rate after each hidden layer
(default = 0.3). Set to 0 to disable dropout.}

\item{batch_norm}{Logical; whether to add `nn_batch_norm1d()` after each
hidden linear layer (default = TRUE).}
}
\value{
A `nn_sequential` object representing the network.
}
\description{
Constructs a multilayer perceptron (MLP) with optional batch normalization
and dropout. Used internally by [survdnn()] to define the model architecture.
}
\keyword{internal}
