% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supernova.R
\name{row_blank}
\alias{row_blank}
\title{A template for a row in an ANOVA table.}
\usage{
row_blank(
  term = NA_character_,
  description = NA_character_,
  ss = NA_real_,
  df = NA_integer_,
  ms = ss/df,
  f = NA_real_,
  pre = NA_real_,
  p = NA_real_
)
}
\arguments{
\item{term}{The name of the term the row describes.}

\item{description}{An optional, short description of the term (pedagogical).}

\item{ss}{The sum of squares for the term (defaults to blank)}

\item{df}{The degrees of freedom the term uses (defaults to blank).}

\item{ms}{The mean square for the term (defaults to \code{ss / df})}

\item{f}{Fisher's F statistic for the term in the model (defaults to blank).}

\item{pre}{The proportional reduction of error the term provides (defaults to blank).}

\item{p}{The p-value of the F (and PRE) for the term in the model (defaults to blank).}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble_row()}} of length 1 with all of the variables initialized.
}
\description{
A template for a row in an ANOVA table.
}
\keyword{internal}
