% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscore.x.R
\name{subscore.x}
\alias{subscore.x}
\title{Computing subscores using Haberman's method based on observed total scores.}
\usage{
subscore.x(test.data)
}
\arguments{
\item{test.data}{A list that contains item responses of all subtests and 
the entire test, which can be obtained using function 'data.prep'.}
}
\value{
\item{summary}{Summary of obtained subscores (e.g., mean, sd).}
\item{PRMSE}{PRMSEs of obtained subscores (for Haberman's methods only).}
\item{subscore.original}{Original observed subscores and total score.} 
\item{subscore.x}{Subscores that are estimated based on the observed total score.}
}
\description{
This function estimates true subscores based on observed total scores 
using the method introduced by Haberman (2008) <doi:10.3102/1076998607302636>.
}
\examples{
       test.data<-data.prep(scored.data,c(3,15,15,20), 
                            c("Algebra","Geometry","Measurement", "Math"))
       
       subscore.x(test.data) 
       
       subscore.x(test.data)$summary
       subscore.x(test.data)$PRMSE
       subscore.x(test.data)$Correlation
       subscore.x(test.data)$Disattenuated.correlation
       subscore.x(test.data)$subscore.x
}
\references{
{
Haberman, S. J. (2008). 
"When can subscores have value?."
 Journal of Educational and Behavioral Statistics, 33(2), 204-229.doi:10.3102/1076998607302636
}
}
