% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Yen.Q3.r
\name{Yen.Q3}
\alias{Yen.Q3}
\title{Computing Yen's Q3 statistic for unidimensional Rasch, 1-, 2-, and 3-PL logistic IRT models}
\usage{
Yen.Q3(scored.data, IRT.model = "2pl")
}
\arguments{
\item{scored.data}{Item response data with rows as individuals and columns as items.}

\item{IRT.model}{IRT model ('Rasch', '1pl', '2pl', or '3pl') to be used.The default option is 2pl.}
}
\value{
\item{Q3}{A matrix of Q3 statistics}

\item{Q3.weighted}{A matrix of Q3 statistics 
as obtained by weighting the residual values to reflect 
the number of examinees with each response pattern.}
}
\description{
This function calculates Yen's Q3 statistics as introduced 
in Yen (1984) <doi: 10.1177/014662168400800201> and 
Yen (1993) <doi: 10.1111/j.1745-3984.1993.tb00423.x> for unidimensional Rasch, 1-, 2-, 
and 3-PL logistic IRT models to assess the local independence assumption.
}
\examples{
 
        Yen.Q3(scored.data,IRT.model="2pl")
        
        Yen.Q3(scored.data)$Q3
        Yen.Q3(scored.data)$Q3.weighted
}
\references{
{
Yen, W. M. (1984).
"Effects of local item dependence on the fit and equating performance of the three-parameter logistic model."
Applied Psychological Measurement, 8(2), 125-145. doi: 10.1177/014662168400800201.
}

{
Yen, W. M. (1993).
"Scaling performance assessments: Strategies for managing local item dependence. " 
ournal of educational measurement, 30(3), 187-213. 
doi: 10.1111/j.1745-3984.1993.tb00423.x.
}
}
