% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{charitable_contributions}
\alias{charitable_contributions}
\title{Charitable Contributions Panel Data}
\format{
A data frame with 470 observations on the following 8 variables.
\describe{
\item{\code{subject}}{a numeric identifier for the subject}
\item{\code{time}}{a numeric time identifier, as a simple integer from 1 to 10}
\item{\code{charity}}{the sum of cash and other property contributions, excluding carry-overs from previous years}
\item{\code{income}}{adjusted gross income}
\item{\code{price}}{1 minus the marginal income tax rate, which is defined on income prior to contributions}
\item{\code{age}}{a dummy variable that equals 1 if the respondent is over 64, 0 otherwise}
\item{\code{ms}}{a dummy variable that equals 1 if the respondent is married, 0 otherwise}
\item{\code{deps}}{the number of claimed dependents, as an integer}}
}
\usage{
charitable_contributions
}
\description{
This is a toy panel data set on charitable contributions across 10 years for
47 taxpayers. It's useful for illustrating the estimation of panel models.
}
\details{
Frees (2003) is the nominal source for these data, as they appear as toy data
sets for use in his book. He in turn cites Banerjee and Frees (1995), though
this citation may have been meant for a 1997 article in \emph{Journal of the
American Statistical Association}. The
actual source for these data as I obtained them is Gujarati (2012). The
underlying source of the raw data are supposedly the 1979-1988
\emph{Statistics of Income} Panel of Individual Tax Returns. Given the opacity of
the data, and its temporal limitations, these data should only be used for
illustration and not inference.

The charitable contributions variable and income variables are very clearly
log-transformed. Banerjee and Price (1997) seem to imply the price variable
is as well.
}
\keyword{datasets}
