% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScaleSpec.R
\name{CombScaleSpec}
\alias{CombScaleSpec}
\alias{print.CombScaleSpec}
\alias{summary.CombScaleSpec}
\title{Combined Scale Specification}
\usage{
CombScaleSpec(name, ..., reverse = character(0))

\method{print}{CombScaleSpec}(x, ...)

\method{summary}{CombScaleSpec}(object, ...)
}
\arguments{
\item{name}{Name of the combined scale or factor}

\item{...}{further arguments passed to or from other methods.}

\item{reverse}{character vector containing names of the underlying subscales
or factors that need to be reversed}

\item{x}{a \emph{CombScaleSpec} object}

\item{object}{a \emph{CombScaleSpec} object}
}
\value{
\code{CombScaleSpec} object
}
\description{
Combine multiple \code{ScaleSpec} objects into one in regards of \code{\link[=sum_items_to_scale]{sum_items_to_scale()}}
function. Useful when one scale of factor contains items of different possible
values or if there is hierarchy of scale or factors.

Also allows combining \code{CombScaleSpec} object if the factor structure have deeper
hierarchy.
}
\examples{
# ScaleSpec objects to Combine

first_scale <- ScaleSpec(
  name = "First Scale",
  item_names = c("Item_1", "Item_2"),
  min = 1,
  max = 5
)

second_scale <- ScaleSpec(
  name = "Second Scale",
  item_names = c("Item_3", "Item_4"),
  min = 0,
  max = 7,
  reverse = "Item_3"
)

third_scale <- ScaleSpec(
  name = "Third Scale",
  item_names = c("Item_5", "Item_6"),
  min = 1,
  max = 5
)

# You can combine few ScaleSpec objects into CombScaleSpec

first_comb <- CombScaleSpec(
  name = "First Comb",
  first_scale,
  second_scale,
  reverse = "Second Scale"
)

print(first_comb)

# And also other CombScaleSpec objects!

second_comb <- CombScaleSpec(
  name = "Second Comb",
  first_comb,
  third_scale
)

print(second_comb)

}
\seealso{
Other item preprocessing functions: 
\code{\link{ScaleSpec}()},
\code{\link{sum_items_to_scale}()}
}
\concept{item preprocessing functions}
