% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transit_table.R
\name{transit_table}
\alias{transit_table}
\title{Create transit table}
\usage{
transit_table(stations, ..., reverse = FALSE)
}
\arguments{
\item{stations}{data.frame which set of stopping points recorded in order of
stopping.}

\item{...}{
  Arguments passed on to \code{\link[dplyr:across]{dplyr::across}}
  \describe{
    \item{\code{.cols}}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to transform.
Because \code{across()} is used within functions like \code{summarise()} and
\code{mutate()}, you can't select or compute upon grouping variables.}
  }}

\item{reverse}{Option to swap the order of the stopping points.}
}
\description{
Create transit table
}
\examples{
# The next stop is stored in the variable of column next_.
jreast_jt \%>\%
  transit_table()
# Switch between inbound and outbound lines.
jreast_jt \%>\%
  transit_table(reverse = TRUE)
}
