% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-kmeans.R
\name{autoplot.qtsclust}
\alias{autoplot.qtsclust}
\title{Plot for \code{qtsclust} objects}
\usage{
\method{autoplot}{qtsclust}(object, ...)
}
\arguments{
\item{object}{An object of class \code{qtsclust} as produced by
\code{\link[=kmeans.qts_sample]{kmeans.qts_sample()}} or \code{\link[=hclust.qts_sample]{hclust.qts_sample()}}.}

\item{...}{Further arguments to be passed to other methods.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
This function creates a visualization of the clustering results obtained on a
sample of QTS and returns the corresponding \link[ggplot2:ggplot]{ggplot2::ggplot} object which
enable further customization of the plot.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
out <- kmeans(vespa64$igp[1:10], n_clusters = 2)
ggplot2::autoplot(out)
\dontshow{\}) # examplesIf}
}
