% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_list.R
\name{update_bucket_list}
\alias{update_bucket_list}
\title{Change the value of a bucket list.}
\usage{
update_bucket_list(
  css_id,
  header = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{css_id}{This is the css id to use, and must be unique in your shiny
app. This defaults to the value of \code{group_id}, and will be appended to the
value "bucket-list-container", to ensure the CSS id is unique for the
container as well as the embedded rank lists.}

\item{header}{Text that appears at the top of the bucket list.  (This is
encoded as an HTML \verb{<p>} tag, so not strictly speaking a header.)  Note
that you must explicitly provide \code{header} argument, especially in the case
where you want the header to be empty - to do this use \code{header = NULL} or
\code{header = NA}.}

\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}
}
\description{
You can only update the \code{header} of the \code{bucket_list}.
To update any of the labels or rank list text, use \code{update_rank_list()}
instead.
}
\examples{
## Example of a shiny app that updates a bucket list and rank list
if (interactive()) {
  app <- system.file(
    "shiny/update/app.R",
    package = "sortable"
  )
  shiny::runApp(app)
}
}
\seealso{
\link{bucket_list}, \link{update_rank_list}
}
