% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_fix_heatmap.R
\name{path_fix_heatmap}
\alias{path_fix_heatmap}
\title{Path-level improvement from fixing high-risk nodes}
\usage{
path_fix_heatmap(all_paths_out, n_nodes = 20, k_paths = 20)
}
\arguments{
\item{all_paths_out}{A list returned by \code{\link[=all_paths_fun]{all_paths_fun()}}, with elements
\code{nodes} and \code{paths}.
\code{nodes} must contain at least the columns \code{name} and
\code{risk_score}. \code{paths} must contain at least the columns
\code{path_id}, \code{path_nodes} (list-column of node names) and
\code{path_risk_score}.}

\item{n_nodes}{Integer, number of top-risk nodes (by \code{risk_score})
to include as rows in the heatmap. Defaults to 20.}

\item{k_paths}{Integer, number of top-risk paths (by \code{path_risk_score})
to include as columns in the heatmap. Defaults to 20.}
}
\value{
A list with two elements:
\itemize{
\item \code{delta_tbl}: a tibble with columns \code{node}, \code{path_id}
and \code{deltaR}, containing the reduction in path risk score
when fixing the node in that path.
\item \code{plot}: a \pkg{ggplot2} object containing the heatmap.
}
}
\description{
Compute how much the risk score of the riskiest paths would
decrease if selected high-risk nodes were made perfectly reliable
(risk fixed to 0), and visualise the result as a heatmap.
}
\details{
For each of the top \code{n_nodes} nodes ranked by \code{risk_score} and
the top \code{k_paths} paths ranked by \code{path_risk_score}, the function
sets the risk of that node to 0 along the path (for all its occurrences)
and recomputes the path risk score under the independence assumption,
using

\deqn{P_k = 1 - \prod_{i=1}^{n_k} (1 - r_{k(v_i)})}

The improvement

\deqn{\Delta P_k = R_{\mathrm{orig}} - R_{\mathrm{fix}}}

is used as the fill value in the heatmap cells.

Bright cells indicate nodes that act as chokepoints for a given path.
Rows with many bright cells correspond to nodes whose refactoring would
improve many risky paths (global chokepoints), while columns with a few
very bright cells correspond to paths dominated by a single risky node.
}
\examples{
data(synthetic_graph)
out <- all_paths_fun(graph = synthetic_graph, alpha = 0.6, beta = 0.3,
gamma = 0.1, complexity_col = "cyclo")
res <- path_fix_heatmap(all_paths_out = out, n_nodes = 20, k_paths = 20)
res

}
