% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_index_fun.R
\name{gini_index_fun}
\alias{gini_index_fun}
\title{Compute the Gini index of a numeric vector}
\usage{
gini_index_fun(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
A numeric scalar giving the Gini index of \code{x}.
}
\description{
Computes the Gini index (a measure of inequality) for a numeric vector.
Non-finite (\code{NA}, \code{NaN}, \code{Inf}) values are removed prior to computation.
If fewer than two finite values remain, the function returns \code{0}.
}
\details{
The Gini index ranges from 0 (perfect equality) to 1 (maximal inequality).
}
\examples{
gini_index_fun(c(1, 1, 1, 1))
gini_index_fun(c(1, 2, 3, 4))
gini_index_fun(c(NA, 1, 2, Inf, 3))

}
