% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{rcat.factor}
\alias{rcat.factor}
\alias{rcategor}
\title{Random Sample for a Categorical Factor}
\usage{
rcat.factor(n, probs)

rcategor(n, probs)
}
\arguments{
\item{n}{Sample size.}

\item{probs}{Either a vector or a matrix of success probabilities.
When \code{probs} is a vector, \code{n} identically distributed random categorical variables
are generated with categories: 1, 2, ..., length(probs)+1.
When \code{probs} is a matrix, the categorical probabilities of the \code{k}th sample are determined by the
\code{k}th row of \code{probs} matrix, i.e., \code{probs[k,]}.}
}
\value{
A factor of length \code{n} with levels: \code{1,2, ...,ncol(probs)+1}.
}
\description{
Matrix version of the categorical distribution. The argument \code{probs} can be a matrix of n rows,
specifying individual (varying in sample) categorical probabilities.
The number of categories generated is equal to \code{ncol(probs)+1}, the levels labeled as: \code{1,...,ncol(probs)+1}.
}
\section{Functions}{
\itemize{
\item \code{rcategor()}: (Deperecated) Random Sample of a Categorical Factor

}}
\examples{

#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with one categorical node with constant
# probabilities
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("race",t=0,distr="rcat.factor",probs=c(0.2,0.1,0.4,0.15,0.05,0.1))
Dset <- set.DAG(D)
simdat <- sim(Dset, n=200, rndseed=1)

#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with a categorical node with varying
# probabilities (probabilities are determined by values sampled for nodes L0 and L1)
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("L0", distr="rnorm", mean=10, sd=5)
D <- D + node("L1", distr="rnorm", mean=10, sd=5)
D <- D + node("L2", distr="rcat.factor", probs=c(abs(1/L0), abs(1/L1)))
Dset <- set.DAG(D)
simdat <- sim(Dset, n=200, rndseed=1)
}
\seealso{
\code{\link{rcat.b1}}, \code{\link{rcat.b0}}
}
