% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{rcategor.int}
\alias{rcategor.int}
\alias{rcat.b1}
\alias{rcat.b0}
\title{Random Sample from Base 1 (rcat.b1) or Base 0 (rcat.b0) Categorical (Integer) Distribution}
\usage{
rcategor.int(n, probs)

rcat.b1(n, probs)

rcat.b0(n, probs)
}
\arguments{
\item{n}{Sample size.}

\item{probs}{Either a vector or a matrix of success probabilities.
When probs is a vector, \code{n} identically distributed random categorical variables are
generated.
When \code{probs} is a matrix, the categorical probabilities of the \code{k}th
sample are determined by the \code{k}th row of probs matrix, i.e., \code{probs[k,]}.}
}
\value{
An integer vector of length \code{n} with range either in \code{0,...,ncol(probs)} or in \code{1,...,ncol(probs)+1}.
}
\description{
Same as \code{}, but returning a vector of sampled integers with range 1, 2, ..., \code{ncol(probs)+1} for \code{rcat.b1}
or range 0, 1, ..., \code{ncol(probs)} for \code{rcat.b0}. For sampling categorical factors see \link{rcat.factor}.
}
\section{Functions}{
\itemize{
\item \code{rcategor.int()}: (Deperecated) Random Sample from Base 1 Categorical (Integer) Distribution

\item \code{rcat.b1()}: Random Sample from Base 1 Categorical (Integer) Distribution

\item \code{rcat.b0()}: Random Sample from Base 0 Categorical (Integer) Distribution

}}
\seealso{
\code{\link{rcat.factor}}
}
