% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{vaeac_get_val_iwae}
\alias{vaeac_get_val_iwae}
\title{Compute the Importance Sampling Estimator (Validation Error)}
\usage{
vaeac_get_val_iwae(
  val_dataloader,
  mask_generator,
  batch_size,
  vaeac_model,
  val_iwae_n_samples
)
}
\arguments{
\item{val_dataloader}{A torch dataloader which loads the validation data.}

\item{mask_generator}{A mask generator object that generates the masks.}

\item{batch_size}{Integer. The number of samples to include in each batch.}

\item{vaeac_model}{The vaeac model.}

\item{val_iwae_n_samples}{Number of samples to generate for computing the IWAE for each validation sample.}
}
\value{
The average iwae over all instances in the validation dataset.
}
\description{
Compute the Importance Sampling Estimator which the vaeac model
uses to evaluate its performance on the validation data.
}
\details{
Compute mean IWAE log likelihood estimation of the validation set. IWAE is an abbreviation for Importance
Sampling Estimator \deqn{\log p_{\theta, \psi}(x|y) \approx \log {\frac{1}{S}\sum_{i=1}^S
p_\theta(x|z_i, y) p_\psi(z_i|y) \big/ q_\phi(z_i|x,y),}} where \eqn{z_i \sim q_\phi(z|x,y)}.
For more details, see \href{https://www.jmlr.org/papers/volume23/21-1413/21-1413.pdf}{Olsen et al. (2022)}.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
