% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.pop_data.R
\name{summary.pop_data}
\alias{summary.pop_data}
\alias{print.summary.pop_data}
\title{Summarize cross-sectional antibody survey data}
\usage{
\method{summary}{pop_data}(object, strata = NULL, ...)

\method{print}{summary.pop_data}(x, ...)
}
\arguments{
\item{object}{a \code{pop_data} object (from \code{\link[=as_pop_data]{as_pop_data()}})}

\item{strata}{a \code{\link[=character]{character()}} specifying grouping column(s)}

\item{...}{unused}

\item{x}{an object of class \code{"summary.pop_data"};
usually, the result of a call to \code{\link[=summary.pop_data]{summary.pop_data()}}}
}
\value{
a \code{summary.pop_data} object,
which is a list containing two summary tables:
\itemize{
\item \code{age_summary} summarizing \code{age}
\item \code{ab_summary} summarizing \code{value}, stratified by \code{antigen_iso}
}
}
\description{
\code{\link[=summary]{summary()}} method for \code{pop_data} objects
}
\examples{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100
summary(xs_data, strata = "catchment")

}
\keyword{internal}
