% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{seg_sf}
\alias{seg_sf}
\alias{seg200_sf}
\alias{seg500_sf}
\alias{seg800_sf}
\alias{seg1000_sf}
\alias{sample_seg_sf}
\title{Segmentation dataset}
\format{
These datasets are objects of class \code{sf} (inherited from \code{tbl_df},
\code{tbl}, \code{data.frame}) with 2 variables:
\itemize{
\item{\code{id}: identification}
\item{\code{geometry}: polygons}
}

\code{seg200_sf}: a dataset with 547 features.
\code{seg500_sf}: a dataset with 215 features.
\code{seg800_sf}: a dataset with 169 features.
\code{seg1000_sf}: a dataset with 158 features.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 215 rows and 2 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 169 rows and 2 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 158 rows and 2 columns.

\code{sample_seg_sf}: a dataset with 6 features extracted from
\code{seg500_sf} dataset.
}
\usage{
seg200_sf

seg500_sf

seg800_sf

seg1000_sf

sample_seg_sf
}
\description{
\code{seg200_sf},\code{seg500_sf},\code{seg800_sf},\code{seg1000_sf}: a dataset containing
segments generated from PlanetScope image, level 3B, acquired on
Feb 18, 2020, with 3.7-meter resolution (Planet Team, 2017), using the
multiresolution segmentation method (Baatz and Schape, 2000).

The data covers the approximately the same area of LEM+ dataset
(see \link{ref_sf}).

The data was post-processed using the spectral difference algorithm on
band 3.

The polygons were simplified using the Douglas-Peucker algorithm in QGIS.

Self-intersections were removed using SAGA's Polygon Self-Intersection.

Segmentation parameters:
\itemize{
\item{\verb{scale parameter}: 200 (\code{seg200_sf}), 500 (\code{seg500_sf}),
800 (\code{seg800_sf}), and 1000 (\code{seg1000_sf})}
\item{\code{shape}: 0.9}
\item{\code{compactness}: 0.1}
}

Spectral difference parameters:
\itemize{
\item{\verb{spectral difference}: 20}
}

Simplification parameter:
\itemize{
\item{\code{distance}: 10-meters}
}

Only those polygons intersecting reference data with an area-perimeter ratio
above 25 were selected.

\code{sample_seg_sf}: a subset of \code{seg_sf} dataset.
}
\examples{
data("seg200_sf", package = "segmetric")
data("seg500_sf", package = "segmetric")
data("seg800_sf", package = "segmetric")
data("seg1000_sf", package = "segmetric")
data("sample_seg_sf", package = "segmetric")
}
\references{
\itemize{
\item Planet Team, 2017. Planet Application Program
Interface: In Space for Life on Earth. San Francisco,
CA. \url{https://www.planet.com}
\item Baatz, M., Schape, A., 2000. Multiresolution
segmentation - an optimization approach for high
quality multi-scale image segmentation. In: Strobl, J.,
Blaschke, T., Griesebner, G. (Eds.), Angewandte
Geographische Informations-Verarbeitung XII.
Wichmann Verlag, Karlsruhe, Germany, pp. 12-23. <>
}
}
\keyword{datasets}
