% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oak_cal_ref_dates.R
\name{oak_cal_ref_dates}
\alias{oak_cal_ref_dates}
\title{Calculate Reference dates in ISO8601 character format.}
\usage{
oak_cal_ref_dates(
  ds_in = dm,
  der_var,
  min_max = "min",
  ref_date_config_df,
  raw_source
)
}
\arguments{
\item{ds_in}{Data frame. DM domain.}

\item{der_var}{Character string. The reference date to be derived.}

\item{min_max}{Minimum or Maximum date to be calculated based on the input.
Default set to Minimum. Values should be min or max.}

\item{ref_date_config_df}{Data frame which has the details of the variables to
be used for the calculation of reference dates.
Should have columns listed below:
raw_dataset_name : Name of the raw dataset.
date_var : Date variable name from the raw dataset.
time_var : Time variable name from the raw dataset.
dformat : Format of the date collected in raw data.
tformat: Format of the time collected in raw data.
sdtm_var_name : Reference variable name.}

\item{raw_source}{List contains all the raw datasets.}
}
\value{
DM data frame with the reference dates populated.
}
\description{
Derive RFSTDTC, RFENDTC, RFXENDTC, RFXSTDTC, etc. based on the input dates and time.
}
\details{
Populate Reference date variables in demographic domain in ISO8601 character format.
}
\examples{
dm <- tibble::tribble(
  ~patient_number,   ~USUBJID, ~SUBJID, ~SEX,
  "001",           "XXXX-001",   "001",  "F",
  "002",           "XXXX-002",   "002",  "M",
  "003",           "XXXX-003",   "003",  "M"
)

ref_date_config_df <- tibble::tribble(
  ~raw_dataset_name,   ~date_var,   ~time_var,      ~dformat, ~tformat, ~sdtm_var_name,
  "ex1_raw",         "EX_ST_DT1", "EX_ST_TM1",  "dd-mm-yyyy",    "H:M",      "RFSTDTC",
  "ex2_raw",         "EX_ST_DT2",          NA, "dd-mmm-yyyy",       NA,      "RFSTDTC",
  "ex1_raw",         "EX_EN_DT1", "EX_EN_TM1",  "dd-mm-yyyy",    "H:M",      "RFENDTC",
  "ex2_raw",         "EX_ST_DT2",          NA, "dd-mmm-yyyy",       NA,      "RFENDTC"
)

ex1_raw <- tibble::tribble(
  ~patient_number, ~EX_ST_DT1,   ~EX_EN_DT1, ~EX_ST_TM1, ~EX_EN_TM1,
  "001",         "15-05-2023", "15-05-2023",    "10:20",    "11:00",
  "001",         "15-05-2023", "15-05-2023",     "9:15",    "10:00",
  "001",         "15-05-2023", "15-05-2023",     "8:19",    "09:00",
  "002",         "02-10-2023", "02-10-2023",  "UNK:UNK",         NA,
  "002",         "03-11-2023", "03-11-2023",    "11:19",         NA
)

ex2_raw <- tibble::tribble(
  ~patient_number,     ~EX_ST_DT2,
  "001",            "11-JUN-2023",
  "002",            "24-OCT-2023",
  "002",            "25-JUL-2023",
  "002",            "30-OCT-2023",
  "002",           "UNK-OCT-2023"
)

raw_source <- list(ex1_raw = ex1_raw, ex2_raw = ex2_raw)

dm_df <- oak_cal_ref_dates(dm,
  der_var = "RFSTDTC",
  min_max = "min",
  ref_date_config_df = ref_date_config_df,
  raw_source
)

}
