% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_study_day.R
\name{derive_study_day}
\alias{derive_study_day}
\title{\code{derive_study_day} performs study day calculation}
\usage{
derive_study_day(
  sdtm_in,
  dm_domain,
  tgdt,
  refdt,
  study_day_var,
  merge_key = "USUBJID"
)
}
\arguments{
\item{sdtm_in}{Input data frame that contains the target date.}

\item{dm_domain}{Reference date frame that contains the reference date.}

\item{tgdt}{Target date from \code{sdtm_in} that will be used to calculate the study
day.}

\item{refdt}{Reference date from \code{dm_domain} that will be used as reference to
calculate the study day.}

\item{study_day_var}{New study day variable name in the output. For
example, AESTDY for AE domain and CMSTDY for CM domain.}

\item{merge_key}{Character to represent the merging key between \code{sdtm_in} and
\code{dm_domain}.}
}
\value{
Data frame that takes all columns from \code{sdtm_in} and a new variable
to represent the calculated study day.
}
\description{
This function takes the an input data frame and a reference data frame (which
is DM domain in most cases), and calculate the study day from reference date
and target date. In case of unexpected conditions like reference date is not
unique for each patient, or reference and input dates are not actual dates,
NA will be returned for those records.
}
\examples{
ae <- data.frame(
  USUBJID = c("study123-123", "study123-124", "study123-125"),
  AESTDTC = c("2012-01-01", "2012-04-14", "2012-04-14")
)
dm <- data.frame(
  USUBJID = c("study123-123", "study123-124", "study123-125"),
  RFSTDTC = c("2012-02-01", "2012-04-14", NA)
)
ae$AESTDTC <- as.Date(ae$AESTDTC)
dm$RFSTDTC <- as.Date(dm$RFSTDTC)
derive_study_day(ae, dm, "AESTDTC", "RFSTDTC", "AESTDY")

}
