% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/building_blocks.R
\name{building_blocks}
\alias{building_blocks}
\alias{max_neighbors}
\alias{min_neighbors}
\alias{mean_neighbors}
\alias{sd_neighbors}
\title{Building Blocks of Peak Functions}
\usage{
max_neighbors(data, w, side, boundary = "reflecting")

min_neighbors(data, w, side, boundary = "reflecting")

mean_neighbors(data, w, side, boundary = "reflecting")

sd_neighbors(data, w, side, boundary = "reflecting")
}
\arguments{
\item{data}{a numeric vector. Length of data must be greater than 1.}

\item{w}{window size. w must be odd and greater than 2 and smaller than double length of data.}

\item{side}{determines which side of neighbors of data point will be used in calculation. "left", "l": left temporal neighbors, "right", "r": right temporal neighbors, "both", "b": left and right temporal neighbors, "all", "a": data point and its left and right temporal neighbors.}

\item{boundary}{determines how data points in the beginning and end of the time series will be treated. "reflecting", "r": reflecting boundary condition, "periodic", "p": periodic boundary condition, "discard", "d", discarding data points in the beginning and end of the time series. See the vignette "Introduction to scorepeak" for detail.}
}
\value{
a numeric vector
}
\description{
Computes max, min, mean, and standard deviation of temporal neighbors.
}
\examples{
data("ecgca102")
max_neighbors(ecgca102, 11, "all")
min_neighbors(ecgca102, 11, "all")
mean_neighbors(ecgca102, 11, "all")
sd_neighbors(ecgca102, 11, "all")
}
\author{
Shota Ochi
}
