% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target.population.demographics.R
\name{target.population.demographics}
\alias{target.population.demographics}
\title{Looks up and returns key demographic statistics for target state to be used for calculating sample weights}
\usage{
target.population.demographics(state)
}
\arguments{
\item{state}{The target state, input as two-letter abbreviation (i.e., "GA" "TX" or "FL"). If no state specified, will use "USA".}
}
\value{
A one row data.frame with the following statistics: black, ba_or_more, hhincome_over50k, age35plus, woman, hispanic
}
\description{
Looks up and returns six key demographic statistics for a target state to be used for calculating sample weights.
             State-level population statistics from U.S. Census Bureau, American Community Survey 5-year estimates.
             Data from state.demographic.info, a saved datafile in sate package.
}
\examples{
   library(sate)
   target.population.demographics(state="FL")

   target.population.demographics()   # will return stats for USA

}
