% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_io.R
\name{validate_parquet_directory}
\alias{validate_parquet_directory}
\title{Validate Parquet Directory}
\usage{
validate_parquet_directory(data_dir, verbose = TRUE)
}
\arguments{
\item{data_dir}{Path to directory to validate}

\item{verbose}{If TRUE, prints validation details (default: TRUE)}
}
\value{
Logical indicating whether the directory is valid
}
\description{
Validates that a directory contains properly formatted Parquet files
and metadata for use with ParquetBackend.
}
\details{
Checks:
\itemize{
\item Directory exists
\item metadata.json exists and is valid
\item All expected Parquet files exist
\item Parquet files have correct dimensions
}
}
\examples{
\dontrun{
validate_parquet_directory("my_connectomes")
}

}
