% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_backend.R
\name{ParquetBackend}
\alias{ParquetBackend}
\title{ParquetBackend Class}
\description{
Backend implementation using Apache Arrow Parquet files with lazy loading.
Matrices are stored as individual Parquet files and loaded on-demand with LRU caching.
}
\section{Super class}{
\code{\link[riemtan:DataBackend]{riemtan::DataBackend}} -> \code{ParquetBackend}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ParquetBackend-new}{\code{ParquetBackend$new()}}
\item \href{#method-ParquetBackend-get_matrix}{\code{ParquetBackend$get_matrix()}}
\item \href{#method-ParquetBackend-get_all_matrices}{\code{ParquetBackend$get_all_matrices()}}
\item \href{#method-ParquetBackend-get_matrices_parallel}{\code{ParquetBackend$get_matrices_parallel()}}
\item \href{#method-ParquetBackend-length}{\code{ParquetBackend$length()}}
\item \href{#method-ParquetBackend-get_dimensions}{\code{ParquetBackend$get_dimensions()}}
\item \href{#method-ParquetBackend-get_metadata}{\code{ParquetBackend$get_metadata()}}
\item \href{#method-ParquetBackend-clear_cache}{\code{ParquetBackend$clear_cache()}}
\item \href{#method-ParquetBackend-get_cache_size}{\code{ParquetBackend$get_cache_size()}}
\item \href{#method-ParquetBackend-clone}{\code{ParquetBackend$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-new"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-new}{}}}
\subsection{Method \code{new()}}{
Load metadata from JSON file


Load a matrix from Parquet file


Update LRU cache with a new matrix


Initialize a ParquetBackend
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$new(data_dir, cache_size = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_dir}}{Path to directory containing Parquet files and metadata.json}

\item{\code{cache_size}}{Maximum number of matrices to cache (default 10)}

\item{\code{i}}{Integer index}

\item{\code{i}}{Integer index}

\item{\code{mat}}{A dppMatrix object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A dppMatrix object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_matrix}{}}}
\subsection{Method \code{get_matrix()}}{
Get a specific matrix by index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_matrix(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Integer index}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A dppMatrix object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_all_matrices"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_all_matrices}{}}}
\subsection{Method \code{get_all_matrices()}}{
Get all matrices (loads all from disk if necessary)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_all_matrices(parallel = NULL, progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parallel}}{Logical indicating whether to use parallel loading (default: NULL, auto-detect)}

\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of dppMatrix objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_matrices_parallel"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_matrices_parallel}{}}}
\subsection{Method \code{get_matrices_parallel()}}{
Load multiple matrices in parallel (batch loading)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_matrices_parallel(indices, progress = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{indices}}{Vector of integer indices to load}

\item{\code{progress}}{Logical indicating whether to show progress (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of dppMatrix objects
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-length"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-length}{}}}
\subsection{Method \code{length()}}{
Get the number of matrices
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$length()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_dimensions"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_dimensions}{}}}
\subsection{Method \code{get_dimensions()}}{
Get matrix dimensions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_dimensions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer p (matrices are p x p)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_metadata()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List containing metadata information
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-clear_cache"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-clear_cache}{}}}
\subsection{Method \code{clear_cache()}}{
Clear the cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$clear_cache()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-get_cache_size"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-get_cache_size}{}}}
\subsection{Method \code{get_cache_size()}}{
Get current cache size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$get_cache_size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of cached matrices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ParquetBackend-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ParquetBackend-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ParquetBackend$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
