% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-get-tools.R
\name{is_in_db}
\alias{is_in_db}
\title{Is in db}
\usage{
is_in_db(id, db = "nucleotide")
}
\arguments{
\item{id}{character, sequence accession ID(s)}

\item{db}{character, database name}
}
\value{
named vector of booleans
}
\description{
Determine whether an id(s)
is/are present in a database.
}
\examples{
library(restez)
# set the restez path to a temporary dir
restez_path_set(filepath = tempdir())
# create demo database
demo_db_create(n = 5)
# in the demo, IDs are 'demo_1', 'demo_2' ...
ids <- c('thisisnotanid', 'demo_1', 'demo_2')
(is_in_db(id = ids))


# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
Other database: 
\code{\link{count_db_ids}()},
\code{\link{db_create}()},
\code{\link{db_delete}()},
\code{\link{db_download}()},
\code{\link{demo_db_create}()},
\code{\link{list_db_ids}()}
}
\concept{database}
