% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\docType{methods}
\name{get_reinstatements}
\alias{get_reinstatements}
\alias{get_reinstatements,Claims-method}
\title{Get reinstatements}
\usage{
get_reinstatements(object)

\S4method{get_reinstatements}{Claims}(object)
}
\arguments{
\item{object}{The object to display}
}
\description{
\code{get_reinstatements} gets the reinstatements induced by XL treaties applied to \code{Claims} (\code{\link{Claims-class}}) object.
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)
p <- aggregate(amount ~ year, c, sum)
claims <- claims(c, p)
treaty_1 <- xl(ded = 100000, lim = 20000, aad = 5000,
               aal = 200000, prm = 0.01, rns = 1)
claims <- apply_treaty(claims, treaty_1)
get_reinstatements(claims)

}
