% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearbyStations.R
\name{nearbyStations}
\alias{nearbyStations}
\title{Find DWD stations close to given coordinates}
\usage{
nearbyStations(
  lat,
  lon,
  radius,
  res = NA,
  var = NA,
  per = NA,
  mindate = NA,
  hasfileonly = TRUE,
  mindex = metaIndex,
  current = FALSE,
  statname = "nearbyStations target location",
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{lat}{Coordinates y component [degrees N/S, range 47:55]}

\item{lon}{Coordinates x component [degrees E/W, range 6:15]}

\item{radius}{Maximum distance [km] within which stations will be selected}

\item{res, var, per}{Restrictions for dataset type as documented in
\code{\link[=selectDWD]{selectDWD()}}. Each can be a vector of entries.
DEFAULTS: NA (ignored)}

\item{mindate}{Minimum dataset ending date (as per metadata). DEFAULT: NA}

\item{hasfileonly}{Logical: only return entries for which there is an
open-access file available? DEFAULT: TRUE}

\item{mindex}{Index with metadata for selecting data.
See \url{https://brry.github.io/rdwd/fileindex.html#metaindex}
DEFAULT: \code{\link{metaIndex}}}

\item{current}{Get current \code{mindex} for \code{res/var/per}? All 3 must be given.
See \code{\link[=selectDWD]{selectDWD()}} for details.
DEFAULT: FALSE}

\item{statname}{Character: name for target location. DEFAULT:
"nearbyStations target location"}

\item{quiet}{Logical: suppress progress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=selectDWD]{selectDWD()}}}
}
\value{
\code{\link{metaIndex}} subset with additional columns "dist" and "url"
}
\description{
Select DWD stations within a given radius around a set of coordinates
}
\examples{

m <- nearbyStations(49.211784, 9.812475, radius=30,
    res=c("daily","hourly"), var=c("precipitation","more_precip","kl"),
    mindate=as.Date("2016-05-30"), statname="Braunsbach catchment center")
# View(m)

# for a continued example of this, see the website use case
# "plot all rainfall values around a given point" (ca section 21):
# browseURL("https://brry.github.io/rdwd")

}
\seealso{
\code{\link[=selectDWD]{selectDWD()}}, \code{\link{metaIndex}},
\href{https://brry.github.io/rdwd/use-case-plot-all-rainfall-values-around-a-given-point.html}{website use case with nearbyStations}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Mar 2017, Aug 2025
}
