% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{fetch}
\alias{fetch}
\title{Fetch a dataset via the Data Retriever}
\usage{
fetch(dataset, quiet = TRUE, data_names = NULL)
}
\arguments{
\item{dataset}{the names of the dataset that you wish to download}

\item{quiet}{logical, if true retriever runs in quiet mode}

\item{data_names}{the names you wish to assign to cells of the list which
stores the fetched dataframes. This is only relevant if you are
downloading more than one dataset.}
}
\value{
Returns a dataframe of \code{dataset}
}
\description{
Each datafile in a given dataset is downloaded to a temporary directory and
then imported as a data.frame as a member of a named list.
}
\examples{
\dontrun{
## fetch the portal Database
portal <- rdataretriever::fetch("portal")
class(portal)
names(portal)
## preview the data in the portal species datafile
head(portal$species)
vegdata <- rdataretriever::fetch(c("plant-comp-ok", "plant-occur-oosting"))
names(vegdata)
names(vegdata$plant_comp_ok)
}
}
