% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SIS_info.R
\name{get_SIS_info}
\alias{get_SIS_info}
\title{Gather information for the NOAA Species Information System (SIS)}
\usage{
get_SIS_info(
  model,
  dir = NULL,
  writecsv = TRUE,
  stock = "StockName",
  final_year = 2019,
  data_year = NULL,
  sciencecenter = "NWFSC",
  Mgt_Council = "NA"
)
}
\arguments{
\item{model}{Output from SS_output}

\item{dir}{Directory where the file will be written}

\item{writecsv}{Write results to a CSV file (where the name will have the
format "[stock]_2019_SIS_info.csv" where \code{stock}
is an additional input}

\item{stock}{String to prepend id info to filename for CSV file}

\item{final_year}{Year of assessment and reference points
(typically will be \code{model[["endyr"]] + 1})}

\item{data_year}{Last year of of timeseries data}

\item{sciencecenter}{Origin of assessment report}

\item{Mgt_Council}{Council jurisdiction. Currently the only option
outside of the default is Gulf of Mexico (\code{"GM"})}
}
\description{
Processes model results contained in the list created by
\code{\link[=SS_output]{SS_output()}} in a format that is more convenient for submission
to SIS. Currently the results are returned invisibly as a list of two tables
and written to a CSV file from which results could be copied into SIS.
In the future some more direct link could be explored to avoid the manual
copy step.
}
\examples{
\dontrun{
# directory with the model output
mydir <- file.path(path.package("r4ss"), "extdata/simple_3.30.13")
# read the model output
model <- SS_output(dir = mydir)
# run get_SIS_info:
info <- get_SIS_info(model, stock = "SimpleExample")
}

}
\seealso{
\code{\link[=SS_output]{SS_output()}}
}
\author{
Ian G. Taylor, Andi Stephens, LaTreese S. Denson
}
