% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2mlm_ci.R
\name{r2mlm_ci}
\alias{r2mlm_ci}
\title{Compute confidence intervals for R-squared in multilevel models.}
\usage{
r2mlm_ci(model, nsim, boottype, confinttype, level = 0.95, progress = T)
}
\arguments{
\item{model}{A model generated using \code{\link[lme4]{lmer}} or
\code{\link[nlme]{nlme}}. Note that models using \code{lmer} must specify
random effects at the end of the model, like so: \code{outcome ~ 1 +
fixed_effects + (random_effects | cluster_variable)}. Anything else (e.g.,
\code{outcome ~ 1 + (random_effects | cluster_variable) + fixed_effects})
will not work.}

\item{nsim}{The number of bootstrapping iterations to use for the
bootstrapped sampling distribution. Common values are 500 and 1000.}

\item{boottype}{A character vector for the type of bootstrapping to perform.
Options are parametric and residual. Parametric bootstrapping assumes
normally distributed residuals, whereas residual does not.}

\item{confinttype}{A character vector for the type of confidence interval to
calculate. Options are norm (for normal), basic, and perc (for percentile).}

\item{level}{The desired confidence level, defaults to 0.95, yielding a 95%
confidence interval.}

\item{progress}{TRUE/FALSE for printing progress bar or not, defaults to
TRUE.}
}
\value{
If the input is a valid model, then the output will be a list of
  R-squared confidence intervals for all 12 measures estimated by the r2mlm
  function.
}
\description{
\code{r2mlm_ci} reads in a multilevel model (MLM) object generated using
\code{\link[lme4]{lmer}} or \code{\link[nlme]{nlme}} along with bootstrap
specifications and returns the upper and lower bounds of confidence intervals
for all R-squared measures available in the \code{r2mlm} framework.
}
\details{
Note that bootstrapping confidence intervals for many R-squared values at
once is computationally intensive, and as a result runs somewhat slowly. For
this reason, the progress bar displays by default.
}
\examples{

\dontrun{
# The "bobyqa" optimizer is required for this particular model to converge

model_lme4 <- lmer(satisfaction ~ 1 + salary_c + control_c + salary_m + control_m +
s_t_ratio + (1 + salary_c + control_c| schoolID), data = teachsat, REML =
TRUE, control = lmerControl(optimizer = "bobyqa"))

r2mlm_ci(model = model_lme4,
         nsim = 100,
         boottype = c("residual"),
         confinttype = c("perc"),
         level = 0.95,
         progress = TRUE)
}

}
\seealso{
Rights, J. D., & Sterba, S. K. (2019). Quantifying explained
  variance in multilevel models: An integrative framework for defining
  R-squared measures. Psychological Methods, 24(3), 309–338.
  <doi:10.1037/met0000184>

Other r2mlm single model functions: 
\code{\link{r2mlm3_manual}()},
\code{\link{r2mlm_long_manual}()},
\code{\link{r2mlm_manual}()},
\code{\link{r2mlm}()}
}
\concept{r2mlm single model functions}
