% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_survrmst.R
\name{psrwe_survrmst}
\alias{psrwe_survrmst}
\title{PS-Integrated Restricted Mean Survival Time (RMST) Test For Comparing Time-to-event Outcomes}
\usage{
psrwe_survrmst(
  dta_psbor,
  pred_tp,
  v_time = "time",
  v_event = "event",
  stderr_method = c("naive", "jk", "sjk", "cjk", "sbs", "cbs", "none"),
  n_bootstrap = 200,
  ...
)
}
\arguments{
\item{dta_psbor}{A class \code{PSRWE_BOR} object generated by
\code{\link{psrwe_borrow}}.}

\item{pred_tp}{A numeric value corresponding to the time of interest
(e.g., 365 days or 1 year)}

\item{v_time}{Column name corresponding to event time}

\item{v_event}{Column name corresponding to event status}

\item{stderr_method}{Method for computing StdErr, see Details}

\item{n_bootstrap}{Number of bootstrap samples (for bootstrap stderr)}

\item{...}{Additional Parameters}
}
\value{
A data frame with class name \code{PSRWE_RST_TESTANA}.
    It contains the test statistics of each stratum as well as the
    Jackknife estimation. The results can be further
    summarized by its S3 method \code{summary}.
    The results can also be analyzed by \code{psrwe_outana} for outcome
    analysis and inference.
}
\description{
RMST test evaluates a two-arm RCT for up to a given time point.
Variance can be estimated by the Jackknife method.
Apply to the case when there is only one external data source and
two-arm RCT.
}
\details{
\code{stderr_method} includes \code{naive} as default which
    mostly follows the Greenwood formula,
    \code{jk} using the Jackknife method within each stratum,
    \code{sjk} using simple Jackknife method for combined estimates
    such as point estimates in single-arm or treatment effects in RCT, or
    \code{cjk} for complex Jackknife method including refitting PS model,
    matching, trimming, calculating borrowing parameters, and
    combining overall estimates.
    Note that \code{sjk} may take a while longer to finish and
    \code{cjk} will take even longer to finish.
    The \code{sbs} and \code{cbs} is for simple and complex Bootstrap
    methods.
}
\examples{
data(ex_dta_rct)
dta_ps_rct <- psrwe_est(ex_dta_rct,
                        v_covs = paste("V", 1:7, sep = ""),
                        v_grp = "Group", cur_grp_level = "current",
                        v_arm = "Arm", ctl_arm_level = "control",
                        ps_method = "logistic", nstrata = 5,
                        stra_ctl_only = FALSE)
ps_bor_rct <- psrwe_borrow(dta_ps_rct, total_borrow = 30)
rst_rmst <- psrwe_survrmst(ps_bor_rct,
                           pred_tp = 365,
                           v_time = "Y_Surv",
                           v_event = "Status")
rst_rmst

}
