% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predictor_terms}
\alias{predictor_terms}
\alias{predictor_terms.projection}
\title{Predictor terms used in a \code{\link[=project]{project()}} run}
\usage{
predictor_terms(object, ...)

\method{predictor_terms}{projection}(object, ...)
}
\arguments{
\item{object}{An object of class \code{projection} (returned by \code{\link[=project]{project()}},
possibly as elements of a \code{list}) from which to retrieve the predictor
terms.}

\item{...}{Currently ignored.}
}
\value{
A character vector of predictor terms.
}
\description{
For a \code{projection} object (returned by \code{\link[=project]{project()}}, possibly as elements of a
\code{list}), this function extracts the combination of predictor terms onto which
the projection was performed.
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The `stanreg` fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Projection onto an arbitrary combination of predictor terms (with a small
# value for `nclusters`, but only for the sake of speed in this example;
# this is not recommended in general):
prj <- project(fit, predictor_terms = c("X1", "X3", "X5"), nclusters = 10,
               seed = 9182)
print(predictor_terms(prj)) # gives `c("X1", "X3", "X5")`
\dontshow{\}) # examplesIf}
}
