% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcv.R
\name{pcv}
\alias{pcv}
\title{Cross-Validation for Profile Analysis}
\usage{
pcv(formula, data, seed = NULL, na.action = "na.fail",
  family = "gaussian", weights = NULL)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}} of the form \code{response ~ terms}.}

\item{data}{An optional data frame, list or environment containing the variables in the model.}

\item{seed}{Should a seed be set? Function defaults to a random seed.}

\item{na.action}{How should missing data be handled? Function defaults to failing if missing data are present.}

\item{family}{A description of the error distribution and link function to be used in the model. See \code{\link{family}}.}

\item{weights}{An option vector of weights to be used in the fitting process.}
}
\value{
An object of class \code{critpat} is returned, listing the f ollowing components: 
\itemize{
\item \code{R2.full}, test of the null hypothesis that R2 = 0  
\item \code{R2.pat}, test that the R2_pattern = 0
\item \code{R2.level}, test that the R2_level = 0
\item \code{R2.full.lvl}, test that the R2_full = R2_level = 0
\item \code{R2.full.pat}, test that the R2_full = R2_pattern = 0}
}
\description{
Implements the cross-validation described in Davison & Davenport (2002).
}
\details{
The \code{pcv} function requires two arguments: criterion and predictor. The criterion corresonds to the dependent variable and the predictor corresponds to the matrix of predictor variables. The function performs the cross-validation technique described in Davison & Davenport (2002) and an object of class \code{critpat} is returned. There the following s3 generic functions are available: \code{summary()},\code{anova()}, \code{print()}, and \code{plot()}. These functions provide a summary of the cross-validation (namely, R2); performs ANOVA of the R2 based on the split for the level, pattern, and overall; provide output similar to \code{lm()}; and plot the estimated parameters for the random split.  Missing data are presently handled by specifying \code{na.action = "na.omit"}, which performs listwise deletion and \code{na.action = "na.fail"}, the default, which causes the function to fail. A seed may also be set for reproducibility by setting the \code{seed}.
}
\references{
Davison, M., & Davenport, E. (2002). Identifying criterion-related patterns of predictor scores using multiple regression. \emph{ Psychological Methods, 7}(4), 468-484. DOI: 10.1037/1082-989X.7.4.468.
}
\seealso{
\code{\link{cpa}},\code{\link{print.critpat}},\code{\link{summary.critpat}},\code{\link{anova.critpat}},\code{\link{plot.critpat}}
}
\keyword{methods}
